#!/usr/bin/tclsh

set JID          jcptest.tclers.tk
set JabberServer localhost
set JabberPort   5347
set Secret       heelgeheim

source jcp.tcl
source wrapper.tcl
package require xmppd::jcp

proc jcptest {type attributes close value children} {
    array set a {from {} to {}}
    array set a $attributes

    switch -exact -- $type {
	message {
            foreach child $children {
                set elt [wrapper::gettag $child]
		if {$elt eq "body" || $elt eq "subject"} {
                    lappend body [wrapper::getcdata $child]
                }
            }
	    puts "MESSAGE: $a(to) $a(from) $body"
    	    message $a(to) $a(from) [join $body "\n"]
	}
	presence {
	    puts "PRESENCE: $a(to) $a(from)"
	    presence $a(to) $a(from)
	}
	iq {
	    puts "IQ:"
	    puts "attributes: $attributes"
	    puts "close:      $close"
	    puts "value:      $value"
	    puts "children:   $children"
	}
	
	default {
	    puts "[string toupper $type]:"
	    puts "attributes: $attributes"
	    puts "close:      $close"
	    puts "value:      $value"
	    puts "children:   $children"
	}
    }
}

proc message {from to body {type chat}} {
    xmppd::jcp::route $::c \
	[wrapper::createxml \
	     [list message \
		  [list xmlns jabber:client \
		       type $type from $from to $to] 0 {} \
		  [list [list body [list xmlns jabber:client] 0 $body {}]]]]
    return
}

proc presence {from to {type ""}} {
    xmppd::jcp::route $::c \
	[wrapper::createxml \
	     [list presence \
		  [list from $from to $to xmlns jabber:client] 1]]
    return
}

xmppd::jcp::configure -component $JID -secret $Secret -handler jcptest \
    -loglevel [lindex $argv 0]
set c [xmppd::jcp::create $JabberServer $JabberPort]

after 100 {
    # presence echo@$JID test@tach.tclers.tk/echo
    presence max@$JID all.tclers.tk
    presence foo@$JID all.tclers.tk
}
after 200 {
    puts too
    message echo@$JID max@all.tclers.tk {Dies ist ein Test}
    puts three
}


vwait forever
