# resolver.tcl - Copyright (C) 2004 Pat Thoyts <patthoyts@users.sf.net>
#
#
#
# -------------------------------------------------------------------------
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
# -------------------------------------------------------------------------
# $Id: resolver.tcl,v 1.1 2004/08/26 09:47:49 pat Exp $

namespace eval ::resolver {
    variable version 1.0.0
    variable channel
    namespace export gethostbyname
}

# -------------------------------------------------------------------------

proc ::resolver::Read {} {
    variable done
    variable channel
    if {[eof $channel]} {
        fileevent $channel readable {}
        return
    }
    set done [gets $channel]
}

proc ::resolver::Write {host} {
    variable channel
    fileevent $channel writable {}
    puts $channel $host
    flush $channel
}

proc ::resolver::Init {} {
    variable done
    variable channel
    set cmd [auto_execok resolver]
    set channel [open |$cmd w+]
    fconfigure $channel -buffering line -blocking 1
}

proc ::resolver::Shutdown {} {
    variable channel
    catch {close $channel} msg
}

proc ::resolver::gethostbyname {host} {
    variable done
    variable channel
    set done {}
    fileevent $channel readable [list [namespace origin Read]]
    fileevent $channel writable [list [namespace origin Write] $host]
    vwait [namespace current]::done
    return $done
}

# package initialization - we will create the child resolver process on loading
# this package.
#
namespace eval ::resolver {
    if {![info exists channel]} {
        Init
    }
}

# -------------------------------------------------------------------------

package provide resolver $::resolver::version

# -------------------------------------------------------------------------

if {! $tcl_interactive} {
    foreach host {binky aol.com www.microsoft.com slashdot.org} {
        set a [resolver::gethostbyname $host]
        foreach h $a {
            puts [list $host $h]
        }
    }
    
    # We don't need to do this explicitly. It'll close when the app exits.
    # Resolver::Shutdown
}
