# VC++ 6.0 Makefile for SQLite 3.2.7                      -*- Makefile -*-
#
# You need to get hold of a copy of awk. There are native Windows versions
# available. This script was developed with GNU awk 3.0.3
#

#### The toplevel directory of the source tree.  This is the directory
#    that contains this "Makefile.in" and the "configure.in" script.

ROOT    = sqlite3
SRCDIR  = $(ROOT)\src
TOOLDIR = $(ROOT)\tool

!ifndef DEBUG
DEBUG = 0
!endif DEBUG
!ifndef PROFILE
PROFILE = 0
!endif
!ifndef SYMBOLS
SYMBOLS = 0
!endif

#### Leave MEMORY_DEBUG undefined for maximum speed.  Use MEMORY_DEBUG=1
#    to check for memory leaks.  Use MEMORY_DEBUG=2 to print a log of all
#    malloc()s and free()s in order to track down memory leaks.
#    
#    SQLite uses some expensive assert() statements in the inner loop.
#    You can make the library go almost twice as fast if you compile
#    with -DNDEBUG=1

#OPTS = -DMEMORY_DEBUG=2
#OPTS = -DMEMORY_DEBUG=1
OPTS = 

!if $(DEBUG)
OUTDIR =Debug
CFLAGS =-Od -Zi -GZ -MDd -D_DEBUG
LDFLAGS=-debug:full -debugtype:cv
!else
OUTDIR =Release
!if $(SYMBOLS)
CFLAGS =-Od -Zi -Op -Gs -MD -DNDEBUG=1
LDFLAGS=-debug -opt:ref -opt:icf,3
!else
CFLAGS =-O2 -Op -Gs -MD -DNDEBUG=1
LDFLAGS=-release -opt:ref -opt:icf,3
!endif
!endif

!if $(PROFILE)
CFLAGS =$(CFLAGS) -Zi
LDFLAGS=$(LDFLAGS) -profile -map
!endif

TMPDIR =$(OUTDIR)\Objects
TMPSRC =$(OUTDIR)\Generated

CC     =cl -nologo
LD     =link -nologo
AR     =lib -nologo
AWK    =awk
COPY   =copy
RMDIR  =rmdir /s /q

#-Fd$(TARGET:.dll=.pdb)
CFLAGS =$(CFLAGS) -W0 -GX -YX -Fp$(TMPDIR)^\
INC    =-I$(SRCDIR) -I$(TMPSRC)
DEFS   =-D_WIN32 -DOS_WIN=1

BCC  =$(CC) $(CFLAGS) $(DEFS)
TCC  =$(CC) $(CFLAGS) $(DEFS)
TCCX =$(TCC) $(OPTS) $(INC) -DWIN32=1 -DTHREADSAFE=1 -DOS_WIN=1
TCCXD = $(TCCX) -D_DLL

#-------------------------------------------------------------------------
# Object files for the SQLite library.
#
LIBOBJ = $(TMPDIR)\alter.obj $(TMPDIR)\analyze.obj $(TMPDIR)\attach.obj \
	$(TMPDIR)\auth.obj $(TMPDIR)\btree.obj $(TMPDIR)\build.obj \
        $(TMPDIR)\callback.obj $(TMPDIR)\complete.obj $(TMPDIR)\date.obj \
        $(TMPDIR)\delete.obj $(TMPDIR)\expr.obj $(TMPDIR)\func.obj \
	$(TMPDIR)\hash.obj $(TMPDIR)\insert.obj $(TMPDIR)\main.obj \
	$(TMPDIR)\opcodes.obj $(TMPDIR)\os.obj $(TMPDIR)\os_unix.obj \
	$(TMPDIR)\os_win.obj $(TMPDIR)\pager.obj $(TMPDIR)\parse.obj \
	$(TMPDIR)\pragma.obj $(TMPDIR)\prepare.obj $(TMPDIR)\printf.obj \
	$(TMPDIR)\random.obj $(TMPDIR)\select.obj $(TMPDIR)\table.obj \
	$(TMPDIR)\tokenize.obj $(TMPDIR)\trigger.obj $(TMPDIR)\update.obj \
        $(TMPDIR)\util.obj $(TMPDIR)\vacuum.obj $(TMPDIR)\vdbe.obj \
	$(TMPDIR)\vdbeapi.obj $(TMPDIR)\vdbeaux.obj $(TMPDIR)\vdbefifo.obj \
	$(TMPDIR)\vdbemem.obj $(TMPDIR)\where.obj $(TMPDIR)\utf.obj \
	$(TMPDIR)\legacy.obj

HDR = \
   $(TMPSRC)\sqlite3.h  \
   $(SRCDIR)\btree.h \
   $(TMPSRC)\config.h \
   $(SRCDIR)\hash.h \
   $(TMPSRC)\opcodes.h \
   $(SRCDIR)\os.h \
   $(SRCDIR)\os_common.h \
   $(SRCDIR)\sqliteInt.h  \
   $(SRCDIR)\vdbe.h  \
   $(TMPSRC)\parse.h

# Header files used by the VDBE submodule

VDBEHDR = $(HDR) $(SRCDIR)/vdbeInt.h

all:	sqlite3.dll libsqlite3.lib sqlite3.exe
sqlite3.exe: setup $(OUTDIR)\sqlite3.exe
sqlite3.dll: setup $(OUTDIR)\sqlite3.dll
libsqlite3.lib: setup $(OUTDIR)\libsqlite3.lib
lemon: setup $(OUTDIR)\lemon.exe

$(OUTDIR)\sqlite3.dll:	$(LIBOBJ) $(TMPDIR)\version.obj $(ROOT)\sqlite3.def
	$(LD) $(LDFLAGS) -dll -def:$(ROOT)\sqlite3.def -out:$@ @<<
$(LIBOBJ)
<<
	$(AR) $(OUTDIR)\sqlite3.lib $(TMPDIR)\version.obj

$(OUTDIR)\libsqlite3.lib: $(LIBOBJ)
	$(AR) -out:$@ @<<
$(LIBOBJ)
<<

$(OUTDIR)\sqlite3.exe: $(OUTDIR)\sqlite3.dll $(TMPDIR)\shell.obj
	$(TCCX) -o $@ $(TMPDIR)\shell.obj $(OUTDIR)\sqlite3.lib

# Rules to build the LEMON compiler generator

$(OUTDIR)\lemon.exe: $(TOOLDIR)\lemon.c $(TOOLDIR)\lempar.c
	$(BCC) -o $@ -Fo$(TMPDIR)\ $(TOOLDIR)\lemon.c

$(TMPDIR)\attach.obj:	$(SRCDIR)\attach.c $(HDR)
$(TMPDIR)\auth.obj:	$(SRCDIR)\auth.c $(HDR)
$(TMPDIR)\btree.obj:	$(SRCDIR)\btree.c $(HDR) $(SRCDIR)\pager.h
$(TMPDIR)\build.obj:	$(SRCDIR)\build.c $(HDR)
$(TMPDIR)\date.obj:	$(SRCDIR)\date.c $(HDR)
$(TMPDIR)\delete.obj:	$(SRCDIR)\delete.c $(HDR)
$(TMPDIR)\expr.obj:	$(SRCDIR)\expr.c $(HDR)
$(TMPDIR)\func.obj:	$(SRCDIR)\func.c $(HDR)
$(TMPDIR)\hash.obj:	$(SRCDIR)\hash.c $(HDR)
$(TMPDIR)\insert.obj:	$(SRCDIR)\insert.c $(HDR)
$(TMPDIR)\main.obj:	$(SRCDIR)\main.c $(HDR)
$(TMPDIR)\opcodes.obj:	$(TMPSRC)\opcodes.c $(HDR)
$(TMPDIR)\os_win.obj:	$(SRCDIR)\os_win.c $(HDR)
$(TMPDIR)\pager.obj:	$(SRCDIR)\pager.c $(HDR) $(SRCDIR)\pager.h
$(TMPDIR)\parse.obj:	$(TMPSRC)\parse.h $(HDR)
$(TMPDIR)\pragma.obj:	$(SRCDIR)\pragma.c $(HDR)
$(TMPDIR)\printf.obj:	$(SRCDIR)\printf.c $(HDR)
$(TMPDIR)\random.obj:	$(SRCDIR)\random.c $(HDR)
$(TMPDIR)\select.obj:	$(SRCDIR)\select.c $(HDR)
$(TMPDIR)\table.obj:	$(SRCDIR)\table.c $(HDR)
$(TMPDIR)\tokenize.obj:	$(SRCDIR)\tokenize.c $(TMPSRC)\keywordhash.h $(HDR)
$(TMPDIR)\trigger.obj:	$(SRCDIR)\trigger.c $(HDR)
$(TMPDIR)\update.obj:	$(SRCDIR)\update.c $(HDR)
$(TMPDIR)\util.obj:	$(SRCDIR)\util.c $(HDR)
$(TMPDIR)\vacuum.obj:	$(SRCDIR)\vacuum.c $(HDR)
$(TMPDIR)\vdbe.obj:	$(SRCDIR)\vdbe.c $(VDBEHDR)
$(TMPDIR)\vdbeapi.obj:	$(SRCDIR)\vdbeapi.c $(VDBEHDR)
$(TMPDIR)\vdbeaux.obj:	$(SRCDIR)\vdbeaux.c $(VDBEHDR)
$(TMPDIR)\vdbemem.obj:	$(SRCDIR)\vdbemem.c $(VDBEHDR)
$(TMPDIR)\where.obj:	$(SRCDIR)\where.c $(HDR)
$(TMPDIR)\utf.obj:	$(SRCDIR)\utf.c $(HDR)
$(TMPDIR)\legacy.obj:	$(SRCDIR)\legacy.c $(HDR)

$(TMPSRC)\sqlite3.h:	$(SRCDIR)\sqlite.h.in
        @type << >$(TMPDIR)\sqlite3h.tmp
NR == FNR {
  VERSION=$$0
  n=split($$0,v,".");
  RELEASE=sprintf("%d%03d%03d", v[1], v[2], v[3]);
  next;
}
/--VERSION-NUMBER--/ { sub(/--VERSION-NUMBER--/,RELEASE); }
/--VERS--/ { sub(/--VERS--/,VERSION); }
{print;}
<<
        @$(AWK) -f $(TMPDIR)\sqlite3h.tmp $(ROOT)\VERSION $(SRCDIR)\sqlite.h.in > $@
	@$(COPY) $@ $(OUTDIR)\sqlite3.h >NUL

$(TMPSRC)\keywordhash.h: $(TOOLDIR)\mkkeywordhash.c
	$(BCC) -o $(TMPDIR)\mkkeywordhash.exe $(OPTS) -Fo$(TMPDIR)\ $(TOOLDIR)\mkkeywordhash.c
	$(TMPDIR)\mkkeywordhash.exe > $@

$(TMPSRC)\config.h:
	@type << >$(TMPDIR)\config_h.c
#include <stdlib.h>
#include <stdio.h>
int main()
{
    printf("#define SQLITE_PTR_SZ %d\n", sizeof(char*));
    exit(0);
}
<<
	$(CC) -o $(TMPDIR)\config_h.exe -Fo$(TMPDIR)\ $(TMPDIR)\config_h.c
	@$(TMPDIR)\config_h.exe > $(TMPSRC)\config.h

$(TMPSRC)\parse.c: $(SRCDIR)\parse.y lemon
	@$(COPY) $(TOOLDIR)\lempar.c $(OUTDIR)\lempar.c >NUL
	@$(COPY) $(SRCDIR)\parse.y $(TMPSRC)\parse.y >NUL
	@$(OUTDIR)\lemon.exe $(TMPSRC)\parse.y
        @$(COPY) $(TMPSRC)\parse.h $(TMPSRC)\parse.h.temp >NUL
        $(AWK) -f $(ROOT)\addopcodes.awk $(TMPSRC)\parse.h.temp > $(TMPSRC)\parse.h

$(TMPSRC)\parse.h: $(TMPSRC)\parse.c

$(TMPSRC)\opcodes.h: $(TMPSRC)\parse.h $(SRCDIR)\vdbe.c
        @$(COPY) $(TMPSRC)\parse.h + $(SRCDIR)\vdbe.c $(TMPDIR)\vdbe.c.temp >NUL
        $(AWK) -f $(ROOT)/mkopcodeh.awk $(TMPDIR)\vdbe.c.temp > $(TMPSRC)\opcodes.h

$(TMPSRC)\opcodes.c: $(TMPSRC)\opcodes.h
        $(AWK) -f $(ROOT)\..\mkopcodec.awk $(TMPSRC)\opcodes.h > $@

$(TMPSRC)\version.c:
	@type << > $@
#include "sqlite3.h"
const char sqlite3_version[] = SQLITE_VERSION;
<<

#-------------------------------------------------------------------------

.SUFFIXES: .c

{$(SRCDIR)}.c{$(TMPDIR)}.obj::
        $(TCCXD) -Fo$(TMPDIR)\ -c @<<
$<
<<

{$(TMPSRC)}.c{$(TMPDIR)}.obj::
        $(TCCXD) -Fo$(TMPDIR)\ -c @<<
$<
<<

#-------------------------------------------------------------------------

setup:
        @if not exist $(OUTDIR) mkdir $(OUTDIR)
        @if not exist $(TMPDIR) mkdir $(TMPDIR)
        @if not exist $(TMPSRC) mkdir $(TMPSRC)

clean:
	@if exist $(TMPDIR) $(RMDIR) $(TMPDIR) >NUL
	@if exist $(TMPSRC) $(RMDIR) $(TMPSRC) >NUL

realclean:
	@if exist $(OUTDIR) $(RMDIR) $(OUTDIR) >NUL
